/*	----------------------------------------------------------
 *  noaarpts.js
 *  beteljuice tweaked
 *  Last modified: 4 May 2021
 *  Populates the dropdown menus using the records began date
 *
 * 	Requires jQuery
 * 	----------------------------------------------------------*/

let rptPath = 'Reports/';
let startYear, endYear;
let startMonth, endMonth;
let rptAvail = {};

let latest_yr = false;
let latest_mon = false;
let gotit = false;

$(document).ready(function() {
    dataLoadedPromise.then(function() {
        startYear = cmx_data.recordsbegandateISO.split('-')[0] * 1;
        startMonth = cmx_data.recordsbegandateISO.split('-')[1] * 1;
        endYear = cmx_data.metdateyesterdayISO.split('-')[0] * 1;
        endMonth = cmx_data.metdateyesterdayISO.split('-')[1] * 1;
		
		monName = ["", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

        // This does the initial disable of future months this year
        rptAvail[endYear] = [];
        for (let m = 1; m < 13; m++) {
            rptAvail[endYear][m] = m <= endMonth;
        }


        // add the year select dropdown values, most recent first
        for (let y = endYear; y >= startYear; y--) {
            let option = $('<option />');
            option.html(y);
            option.val(y);
			
                    $.ajax({
                        url:  rptPath + 'NOAAYR' + y + '.txt',
						async: false,
                        type: 'HEAD',
						success: function() {
							if(latest_yr === false) {
								latest_yr = y;
								getYearRpt({value: endYear}); // will be overwritten by latest month report when found
								option.attr('selected', true);
							}
							$('#year').append(option);
						},
                        error: function() {
                            // ...disable any year that should be available but isn't
                            option.prop('disabled', true);
							option.addClass('disabled');
							$('#year').append(option);
							
                        }
                    });
			

            rptAvail[y] = [];

            // The start and end years may be short, so no point in checking months that are out of range
            let monSt, monEnd;
            if (y == startYear) {
                monSt = startMonth;
                monEnd = 12;
            } else if (y == endYear) {
                monSt = 1;
                monEnd = endMonth;
            } else {
                monSt = 1;
                monEnd = 12;
            }
			
			if(y == latest_yr) {
				manner = 'false';
			} else {
				manner = 'true';
			}

            // we need to process every month though, so we can disbale those out of range as well as MIA
            for (let m = 1; m <= 12; m++) {
// put defined monthname in selector
$('#mon' + m).html(monName[m]);
                // assume this month isn't available
                rptAvail[y][m] = false;

                if (m >= monSt && m <= monEnd) {
                    // assume it's there, then we only have to check for failure
                    rptAvail[y][m] = true;
                    // checking...
                    $.ajax({
						async: manner,
                        url: rptPath + 'NOAAMO' + pad2(m) + pad2(y - 2000) + '.txt',
                        type: 'HEAD',
						success: function() {
							if(y == latest_yr) {
								latest_mon = m;
							}
						},
                        error: function() {
                            rptAvail[y][m] = false;
                            // if we are in the year currently being displayed...
                            if (y == $('#year').val()) {
                                // ...disable of any months that should be available but aren't
                                $('#mon' + m).prop('disabled', true);
                            }
                        },
						complete: function() {
							if(gotit === false) {
								if(latest_yr && latest_mon && m == monEnd) { // not foolproof, still possible for previous ajax not to have completed.
									getMonRpt(pad2(latest_mon));
									gotit = true;
								}
							}
						}
                    });
                }
            }
        }
    });


    // when the selector is "clicked", then hide it with the w3-hide class so we do not have to mouseoff or touch elsewhere to hide
    $('#monSelector').each(function() {
        $(this).on('click touchend', function(event) {
            if (event.type == 'click')
                $('#monSelector').addClass('w3-hide');
        });
    });

    // when the month button is "clicked" or mouseover, clear any hide we added when a month was previously selected
    $('#monButton').on('click touchend mouseover', function(event) {
        $('#monSelector').removeClass('w3-hide');
    });
});

// pad two digit numbers with a leading zero
let pad2 = function (num) {
    return (num < 10 ? '0' : '') + num;
}

// Script assumes that reports use the default name format
let getMonRpt = function(month) {
    let yr  = $('#year').val();
console.log(yr+ ' > ' +month);
// add a cache buster - doesn't seem to be auto for txt file
buster = new Date().getTime();

    reqRpt = rptPath + 'NOAAMO' + month + pad2(yr - 2000) + '.txt?_' +buster;

    $.ajax({
        url: reqRpt,
        dataType: 'text',
        success: function(data) {
            $('#noaareport').text(data);
$('#monButton').html(monName[month *1]);
        },
        error: function() {
            alert('Did not find the required report\n\nPlease try another date');
        }
    });
};

// Script assumes that reports use the default name format
let getYearRpt = function(yr) {
    let reqRpt = rptPath + 'NOAAYR' + yr.value + '.txt';

    // get the report text
    $.ajax({
        url: reqRpt,
        dataType: 'text',
        success: function(data) {
            $('#noaareport').text(data);
$('#monButton').html("<i>Choose Your Month</i>");

        },
        error: function() {
            alert('Did not find the required report\n\nPlease try another date');
        }
    });

    // set the month buttons for the new year
    for (let m = 1; m < 13; m++) {
        $('#mon' + m).prop('disabled', !rptAvail[yr.value][m]);
    }
};

